define(['app'], function(app) {
	'use strict';

	app.constant('assessmentModels', {
		'yesNo': {
			"type": "MULTI_OPTION_SINGLE_RESPONSE",
			"prompt": "",
			"questionChoice": [{
				"choiceNumber": "1",
				"property": [{
					"name": "displayText",
					"value": "Yes"
				}]
			},
			{
				"choiceNumber": "2",
				"property": [{
					"name": "displayText",
					"value": "No"
				}]
			}]
		},
		'emptyQuestionChoice': {
			"choiceNumber": "",
			"property": [{
				"name": "displayText",
				"value": ""
			}]
		},
		'singleSelect': {
			"type": "MULTI_OPTION_SINGLE_RESPONSE",
			"prompt": "",
			"questionChoice": []
		},
		'multiSelect': {
			"type": "MULTI_OPTION_MULTI_RESPONSE",
			"prompt": "",
			"questionChoice": []
		},
		'slider': {
			"type": "SLIDER",
			"prompt": "",
			"questionProperties": [{
				"name": "minValue",
				"value": "1"
			},
			{
				"name": "maxValue",
				"value": "5"
			},
			{
				"name": "minLabel",
				"value": ""
			},
			{
				"name": "maxLabel",
				"value": ""
			},
			{
				"name": "increment",
				"value": "1"
			}]
		},
		'text': {
            "type" : "FREE_TEXT",
            "prompt" : "",
            "questionProperties" : [ 
                {
                    "name" : "maxLength",
                    "value" : "250"
                }
            ]
        },
        'blankAssessment': {
        	"uniqueTitle": "",
			"purpose": "",
			"healthAssessment": true,
			"waitingPeriod": 0,
			"notes": "",
			"version": 1,
			"authenticationStrategy": "BASIC",
			"scoringAlgorithm": "UNSCORED",
			"publish": false,
			"status": "Draft",
			"createdDate": null, 
			"lastModifiedDate": null,
			"question": []
        }
	});
});